//------------------------------------------------------------------------------------------------------------------------------------------------
// PA2 Extras - Powah
//------------------------------------------------------------------------------------------------------------------------------------------------
// Author: RicTheCoder
//
// This script uses the KubeJS Powah to add some extra fluids and sources into the Powah mod, just to make it overall more compatible with the 
// other mods and allow easy addition.
//------------------------------------------------------------------------------------------------------------------------------------------------

// Magmatic Fluids to be added to the Magmator
// - Key is the fluid id, value is the heat (Lava is 10000)
/*const magmaticFluid = {
	"cyclic:magma": 20000,
	"industrialforegoing:biofuel": 30000,
	"thermal:refined_fuel": 40000,
	"createaddition:bioethanol": 30000,
	"mekanismgenerators:bioethanol": 30000,
	"thermal:tree_oil": 5000
}*/

// Heat Sources for the Thermal Generator
// - Key is the block id, value is the hotness (Lava is 1000)
/*const heatSource = {
	"allthecompressed:blazing_crystal_block_1x": 3300, // 2800 + (500 * Compression)
	"allthecompressed:blazing_crystal_block_2x": 3800,
	"allthecompressed:blazing_crystal_block_3x": 4300,
	"allthecompressed:blazing_crystal_block_4x": 4800,
	"allthecompressed:blazing_crystal_block_5x": 5300,
	"allthecompressed:blazing_crystal_block_6x": 5800,
	"allthecompressed:blazing_crystal_block_7x": 6300,
	"allthecompressed:blazing_crystal_block_8x": 6800,
	"allthecompressed:blazing_crystal_block_9x": 7300,
	"cyclic:magma": 2000, // Lava * 2
	"draconicevolution:infused_obsidian": 2400, // MagmaBlock * 3
	"kubejs:blaze_block": 2000, // Less 800 than Blazing Crystal
	"mekanism:superheating_element": 3000, // Makes sense I guess
	"kubejs:architron": 10000 // Gives some usability to the Archi- blocks
}*/

// Coolants for the Thermal Generator
// - Key is the fluid id, value is the coolness (Water is 1)
/*const coolant = {
	"industrialforegoing:ether_gas": 24,
	"thermal:ender": 3,
	"mekanism:hydrogen": 8,
	"mekanism:heavy_water": 3,
	"enlightened_end:ooze_fluid": 5,
	"integrateddynamics:liquid_chorus": 4,
	"minecraft:milk": 2,
	"mekanism:ethylene": 12,
	"the_bumblezone:royal_jelly_fluid_still": 74
}*/

//---[CODE]---------------------------------------------------------------------------------------------------------------------------------------

// Register the fluids to the magmator
/*PowahEvents.registerMagmaticFluid(event => {
	Object.keys(magmaticFluid).forEach(fluid => {
		event.add(fluid, magmaticFluid[fluid]);
	});
});*/

// Register the heat sources to the Thermal Generator
/*PowahEvents.registerHeatSource(event => {
	Object.keys(heatSource).forEach(block => {
		event.add(block, heatSource[block]);
	});
});*/

// Register the coolants to the Thermal Generator + Reactor
/*PowahEvents.registerCoolants(event => {
	Object.keys(coolant).forEach(entry => {
		event.addFluid(entry, coolant[entry]);
	});
});*/